package w83b.w83bUtilidades;

import java.io.ByteArrayOutputStream;
import java.util.Date;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;

import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

/**
 * 
 * @author 
 *
 */
public class W83bUtilidadesExcel{
	
	
	public HSSFCellStyle styleTextoPar;
	public HSSFCellStyle styleTextoImpar;
	public HSSFCellStyle styleTextoPar10;
	public HSSFCellStyle styleTextoImpar10;
	public HSSFCellStyle styleTextoLabel;
	public HSSFCellStyle styleTextoLabelCentrado;
	public HSSFCellStyle styleTexto;
	public HSSFCellStyle styleTexto9;
	public HSSFCellStyle styleTextoAutoAjustado;
	public HSSFCellStyle styleTextoParNoBordes;
	public HSSFCellStyle styleTextoImparNoBordes;
	public HSSFCellStyle styleTextoParCentrado;
	public HSSFCellStyle styleTextoImparCentrado;
	public HSSFCellStyle styleTextoParNoJustif;
	public HSSFCellStyle styleTextoImparNoJustif;
	public HSSFCellStyle styleTextoParJustifCombinada;
	public HSSFCellStyle styleTextoImparJustifCombinada;
	public HSSFCellStyle styleTextoParNumero;
	public HSSFCellStyle styleTextoImparNumero;
	public HSSFCellStyle styleTextoParNumeroCentrado;
	public HSSFCellStyle styleTextoImparNumeroCentrado;
	public HSSFCellStyle styleCabecera;
	public HSSFCellStyle styleCabeceraIzquierda;
	public HSSFCellStyle styleFilaJustificado;
	public HSSFCellStyle styleTextoCabeceraTabla;
	public HSSFCellStyle styleTextoCabeceraBlancoTabla;
	public HSSFCellStyle styleNegrita;
	public HSSFCellStyle styleNegritaBordeIzq;
	public HSSFCellStyle styleNegritaBordeAbajoIzq;
	public HSSFCellStyle styleNegritaSub;
	public HSSFCellStyle styleNegritaSubCentrado;
	public HSSFCellStyle styleNegritaSubTabla;
	public HSSFCellStyle styleBordeAbajo;
	public HSSFCellStyle styleBordeAbajoDcha;
	public HSSFCellStyle styleBordeAbajoDchaArriba;
	public HSSFCellStyle styleBordeArriba;
	public HSSFCellStyle stylePorcentajesDcha;
	public HSSFCellStyle styleBordeDcha;
	public HSSFCellStyle styleBordeIzda;
	public HSSFCellStyle styleBordeDchaArriba;
	public HSSFCellStyle styleBordeIzdaArriba;
	public HSSFCellStyle styleBordeIzdaArribaNegrita;
	public HSSFCellStyle styleBordeDchaAbajo;
	public HSSFCellStyle styleBordeIzdaAbajo;
	public HSSFCellStyle styleCentrado;
	public HSSFCellStyle styleCentradoSubrayado;
	public HSSFCellStyle styleCentradoImpar;
	public HSSFCellStyle styleCentradoNumeroFormateado;
	public HSSFCellStyle styleDerechaNumeroFormateado;
	public HSSFCellStyle styleBordeArribaFormateado;
	public HSSFCellStyle sytleNegritaFormateado;
	public HSSFCellStyle styleTextoParNumeroCentradoFormateado;
	public HSSFCellStyle estiloExcelCitacionesTitulos;
	public HSSFCellStyle estiloExcelCitaciones;
	public HSSFCellStyle styleCadena9Justif;
	public HSSFCellStyle styleFuenteTexto;
	
	public W83bUtilidadesExcel(HSSFWorkbook wb) {
		super();
		this.definirEstilos(wb);//NOPMD
	}


	/**
	 * definirEstilos.
	 * @param wb HSSFWorkbook 
	 */
	public void  definirEstilos (HSSFWorkbook wb){
		 
		//creating a custom palette for the workbook
		 HSSFPalette palette = wb.getCustomPalette();
		 palette.setColorAtIndex((short)22, (byte) 216, (byte) 216, (byte) 216); 
		 palette.setColorAtIndex((short)55, (byte) 191, (byte) 191, (byte) 191); 
		
		
		this.styleTextoPar = W83bClsEstilosExcel.estiloParCadena(wb);
		this.styleTextoImpar = W83bClsEstilosExcel.estiloInparCadena(wb);
		this.styleTextoPar10 = W83bClsEstilosExcel.estiloParCadena10(wb);
		this.styleTextoImpar10 = W83bClsEstilosExcel.estiloInparCadena10(wb);
		this.styleTextoLabel = W83bClsEstilosExcel.estiloInparCadena10(wb);
		this.styleTextoLabelCentrado = W83bClsEstilosExcel.estiloInparCadena10Center(wb);
		this.styleTexto = W83bClsEstilosExcel.estiloCadena10(wb);
		this.styleTexto9 = W83bClsEstilosExcel.estiloCadena9(wb);
		this.styleCadena9Justif = W83bClsEstilosExcel.estiloCadena9Justif(wb);
		this.styleTextoAutoAjustado = W83bClsEstilosExcel.estiloCadenaAutoAjust(wb);
		this.styleTextoParCentrado = W83bClsEstilosExcel.estiloParCadenaCentrado(wb);
		this.styleTextoImparCentrado = W83bClsEstilosExcel.estiloInparCadenaCentrado(wb);
		this.styleCentradoNumeroFormateado = W83bClsEstilosExcel.styleCentradoNumeroFormateado(wb);
		this.styleDerechaNumeroFormateado = W83bClsEstilosExcel.styleDerechaNumeroFormateado(wb);
		this.styleBordeArribaFormateado = W83bClsEstilosExcel.styleBordeArribaFormateado(wb);
		this.sytleNegritaFormateado = W83bClsEstilosExcel.sytleNegritaFormateado(wb);
		this.styleTextoParNumeroCentradoFormateado = W83bClsEstilosExcel.styleTextoParNumeroCentradoFormateado(wb);
		this.styleTextoParNoBordes = W83bClsEstilosExcel.estiloParCadenaNoBordes(wb);
		this.styleTextoImparNoBordes = W83bClsEstilosExcel.estiloInparCadenaNoBordes(wb);
		this.styleTextoImparCentrado = W83bClsEstilosExcel.styleTextoImparCentrado(wb);
		this.styleTextoParNoJustif = W83bClsEstilosExcel.estiloParCadenaNoJustif(wb);
		this.styleTextoImparNoJustif = W83bClsEstilosExcel.estiloInparCadenaNoJustif(wb);
		this.styleTextoParJustifCombinada = W83bClsEstilosExcel.estiloParCadenaJustifCombinada(wb);
		this.styleTextoImparJustifCombinada = W83bClsEstilosExcel.estiloInparCadenaJustifCombinada(wb);
		this.styleTextoParNumero = W83bClsEstilosExcel.estiloParNumero(wb);
		this.styleTextoImparNumero = W83bClsEstilosExcel.estiloInparNumero(wb);
		this.styleTextoParNumeroCentrado = W83bClsEstilosExcel.estiloParNumeroCentrado(wb);
		this.styleTextoImparNumeroCentrado = W83bClsEstilosExcel.estiloInparNumeroCentrado(wb);
		this.styleCabecera = W83bClsEstilosExcel.estiloCabecera(wb);
		this.styleCabeceraIzquierda = W83bClsEstilosExcel.estiloCabeceraIzquierda(wb);
		this.styleFilaJustificado = W83bClsEstilosExcel.estiloFilaJustificado(wb);
		this.styleTextoCabeceraTabla = W83bClsEstilosExcel.estiloCabeceraTabla(wb);
		this.styleTextoCabeceraBlancoTabla = W83bClsEstilosExcel.estiloCabeceraBlancoTabla(wb);
		this.styleNegrita = W83bClsEstilosExcel.estiloNegrita(wb);
		this.styleNegritaBordeIzq = W83bClsEstilosExcel.estiloNegritaBordeIzq(wb);
		this.styleNegritaBordeAbajoIzq = W83bClsEstilosExcel.estiloNegritaBordeAbajoIzq(wb);
		this.styleNegritaSub = W83bClsEstilosExcel.estiloNegritaSubrayado(wb);
		this.styleNegritaSubCentrado = W83bClsEstilosExcel.estiloNegritaSubrayadoCentrado(wb);
		this.styleNegritaSubTabla = W83bClsEstilosExcel.estiloNegritaSubrayadoTabla(wb);
		this.styleBordeAbajo = W83bClsEstilosExcel.styleBordeAbajo(wb);
		this.styleBordeAbajoDcha = W83bClsEstilosExcel.styleBordeAbajoDcha(wb);
		this.styleBordeAbajoDchaArriba = W83bClsEstilosExcel.styleBordeAbajoDchaArriba(wb);
		this.styleBordeArriba = W83bClsEstilosExcel.styleBordeArriba(wb);
		this.stylePorcentajesDcha = W83bClsEstilosExcel.stylePorcentajesDcha(wb);
		this.styleBordeDcha = W83bClsEstilosExcel.styleBordeDcha(wb);
		this.styleBordeIzda = W83bClsEstilosExcel.styleBordeIzda(wb);
		this.styleBordeDchaArriba = W83bClsEstilosExcel.styleBordeDchaArriba(wb);
		this.styleBordeIzdaArriba = W83bClsEstilosExcel.styleBordeIzdaArriba(wb);
		this.styleBordeIzdaArribaNegrita = W83bClsEstilosExcel.styleBordeIzdaArribanegrita(wb);
		this.styleBordeDchaAbajo = W83bClsEstilosExcel.styleBordeDchaAbajo(wb);
		this.styleBordeIzdaAbajo = W83bClsEstilosExcel.styleBordeIzdaAbajo(wb);
		this.styleCentrado = W83bClsEstilosExcel.styleCentrado(wb);
		this.styleCentradoSubrayado = W83bClsEstilosExcel.styleCentradoSubrayado(wb);
		this.styleCentradoImpar = W83bClsEstilosExcel.styleCentradoImpar(wb);
		this.styleTextoParCentrado = W83bClsEstilosExcel.styleTextoParCentrado(wb);
		this.estiloExcelCitacionesTitulos = W83bClsEstilosExcel.estiloExcelCitacionesTitulos(wb);
		this.estiloExcelCitaciones = W83bClsEstilosExcel.estiloExcelCitaciones(wb);
		this.styleFuenteTexto = W83bClsEstilosExcel.styleFuenteTexto(wb);
	}
	
	
	/**
	 * tipoFilaCadena.
	 * @param fila int 
	 * @return HSSFCellStyle
	 */
	public HSSFCellStyle tipoFilaCadena(int fila)
	{
		if (fila % 2 == 0)
		{
			return this.styleTextoPar;
		}
		else
		{
			return this.styleTextoImpar;
		}
	}

  public static byte[] fncExcelToBytes(HSSFWorkbook hsPfLibro) throws Exception
  {
        ByteArrayOutputStream outPutStream = new ByteArrayOutputStream();
        hsPfLibro.write(outPutStream);
        byte[] bytes = outPutStream.toByteArray();
        outPutStream.close();
        
        return bytes;

  }
  
  public static void crearCabeceraPieEstandar(HSSFSheet sheet, String idioma,W83bUsuarioXLNetsBean usuario ) throws Exception{
	  HSSFHeader.fontSize((short)8);
      HSSFHeader header = sheet.getHeader();
      header.setLeft(HSSFHeader.fontSize((short) 8)+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.eleccionesSindicales",idioma));
      header.setRight(HSSFHeader.fontSize((short) 8)+" "+W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
      
      HSSFFooter footer = sheet.getFooter();

      footer.setCenter(HSSFFooter.fontSize((short) 8)+usuario.getCalleListadosFormateada());
      footer.setRight(HSSFFooter.fontSize((short) 8)+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{footer.page()}));
  }

  public void copyRow(HSSFWorkbook workbook, HSSFSheet worksheet, int sourceRowNum, int destinationRowNum)
  {
      // Get the source / new row
      HSSFRow newRow = worksheet.getRow(destinationRowNum);
      HSSFRow sourceRow = worksheet.getRow(sourceRowNum);
   
      // If the row exist in destination, push down all rows by 1 else create a new row
      if (newRow != null)
      {
          worksheet.shiftRows(destinationRowNum, worksheet.getLastRowNum(), 1);
         
      }
      else
      {
          newRow = worksheet.createRow(destinationRowNum);
         
      }
      newRow.setHeight(sourceRow.getHeight());
      // Loop through source columns to add to new row
      for (int i = 0; i < sourceRow.getLastCellNum(); i++)
      {
          // Grab a copy of the old/new cell
          HSSFCell oldCell = sourceRow.getCell((short)i);
          HSSFCell newCell = newRow.createCell((short)i);
   
          // If the old cell is null jump to next cell
          if (oldCell == null)
          {
              newCell = null;
              continue;
          }
   
          // Copy style from old cell and apply to new cell
          HSSFCellStyle newCellStyle = workbook.createCellStyle();
          newCellStyle=oldCell.getCellStyle(); ;
          newCell.setCellStyle( newCellStyle);
   
        // Set the cell data type
          newCell.setCellType(oldCell.getCellType());
   
         
          newCell.setCellValue(oldCell.getStringCellValue());
                 
         
      }
   
      // If there are are any merged regions in the source row, copy to new row
      for (int i = 0; i < worksheet.getNumMergedRegions(); i++)
      {
        Region cellRangeAddress = worksheet.getMergedRegionAt(i);
          if (cellRangeAddress.getRowFrom() == sourceRow.getRowNum())
          {
        	  Region newCellRangeAddress = new Region(newRow.getRowNum(),cellRangeAddress.getColumnFrom(),newRow.getRowNum()+ (cellRangeAddress.getRowFrom()-cellRangeAddress.getRowTo()), cellRangeAddress.getColumnTo());//NOPMD	  
              worksheet.addMergedRegion(newCellRangeAddress);
          }
      }
   
  }
  
  public static String mayusculasCampoExcel(String elemento){

		if (elemento!=null){
			return elemento.toUpperCase();
		}
		else{
			return elemento;
		}
		
	}
  
  public static String blancoCampoExcel(String elemento){

		if ("0".equals(elemento)){
			return "";
		}
		else{
			return elemento;
		}
		
	}
   

}
